---
generated_at: 2026-01-20 11:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-Resource Browser

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠が確認できたため、優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）

- E-01: `Examples/IO Examples/ResourceBrowser/Form1.frm` 行5: BorderStyle = 1 'Fixed Single
- E-02: `Examples/IO Examples/ResourceBrowser/Form1.frm` 行12-13: MaxButton = False, MinButton = False
- E-03: `Examples/IO Examples/ResourceBrowser/Form1.frm` 行2: Object = MSCOMCTL.OCX
- E-04: `Examples/IO Examples/ResourceBrowser/Form1.frm` 行3: Object = COMDLG32.OCX
- E-05: `Examples/IO Examples/ResourceBrowser/Form1.frm` 行67: Private mResources As New Hashtable
- E-06: `Examples/IO Examples/ResourceBrowser/Form1.frm` 行195-197: Form_Load
- E-07: `Examples/IO Examples/ResourceBrowser/Form1.frm` 行211-216: mnuFileOpenRes_Click
- E-08: `Examples/IO Examples/ResourceBrowser/Form1.frm` 行215: Cor.NewResourceReader(FileName)
- E-09: `Examples/IO Examples/ResourceBrowser/Form1.frm` 行203-209: mnuFileOpenEXE_Click
- E-10: `Examples/IO Examples/ResourceBrowser/Form1.frm` 行207: Cor.NewWinResourceReader(FileName)
- E-11: `Examples/IO Examples/ResourceBrowser/Form1.frm` 行71-106: LoadResources
- E-12: `Examples/IO Examples/ResourceBrowser/Form1.frm` 行108-144: ShowResource
- E-13: `Examples/IO Examples/ResourceBrowser/Form1.frm` 行153-180: GetTypeName
- E-14: `docs/code-to-docs/画面一覧/画面一覧.csv` 行11: 画面情報定義
- E-15: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行84-88: 機能マッピング情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BorderStyle = Fixed Single でサイズ変更不可 | E-01 | ○ |
| C-02 | 最大化・最小化ボタン無効 | E-02 | ○ |
| C-03 | MSCOMCTL.OCXを使用 | E-03 | ○ |
| C-04 | COMDLG32.OCXを使用 | E-04 | ○ |
| C-05 | mResourcesはHashtableでリソース保存 | E-05 | ○ |
| C-06 | Form_LoadでInit呼び出し | E-06 | ○ |
| C-07 | mnuFileOpenRes_ClickでRESファイルを開く | E-07 | ○ |
| C-08 | Cor.NewResourceReaderでResourceReader作成 | E-08 | ○ |
| C-09 | mnuFileOpenEXE_ClickでEXE/DLL/OCXを開く | E-09 | ○ |
| C-10 | Cor.NewWinResourceReaderでWinResourceReader作成 | E-10 | ○ |
| C-11 | LoadResourcesでリソース読み込み・表示 | E-11 | ○ |
| C-12 | ShowResourceでプレビュー表示 | E-12 | ○ |
| C-13 | GetTypeNameでリソース種別を文字列変換 | E-13 | ○ |
| C-14 | 画面はサンプル/IOカテゴリ | E-14 | ○ |
| C-15 | ResourceReader, WinResourceReader, Hashtable機能に関連 | E-15 | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で根拠なしの項目はありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [x] 全ての主張にソースコード根拠が対応している
- [ ] 不正なファイル形式に対するエラーハンドリングを確認
- [ ] サポートされるリソース種別を確認
